

#version 120
#extension GL_EXT_gpu_shader4 : enable

attribute vec3 p0; 
attribute vec3 p1; 
attribute vec2 texcoord; 
attribute vec2 texcoord2;  

uniform mat4 viewproj; 
uniform mat4 view;
uniform mat4 proj;
uniform mat4 world;
uniform vec3 eyePos; 
uniform float grow; //levels*time
uniform float linesize = 0.5f;

uniform float max_radius; 
uniform float t; 

uniform float tracks[32];
varying vec2 tc; 
varying vec3 color; 
varying float fogCoef;
varying float a1;
varying float la; 
//random E[-1, 1]
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}



float fogFar = 1700.0;
float lineWidth = 1.5;
void main()
{

	vec4 vp0 = view*vec4(p0, 1.0);
	vec4 vp1 = view*vec4(p1, 1.0);
	vec4 mid = mix(vp1,vp0, texcoord.y);
	vec3 mid2 = mix(p1,p0, texcoord.y);
///	vp0*=proj;
//	vp1*=proj;
	vec4 dp0 = proj*vp0;
	vec4 dp1 = proj*vp1;
	vec2 dir = normalize(dp1.xy-dp0.xy);
	dir.y = -dir.y;

	vec4 npos = mid;
	vec3 add = mix(-vec3(dir.yx, 0), vec3(dir.yx, 0), texcoord.x);
//	npos --=  lineWidth*vec4(add, 0.0);

	gl_Position = proj*npos;//npos;
	gl_Position += lineWidth*vec4(add, 0.0);

	tc = texcoord.xy;
	float dist = clamp(1.0-length(mid2.xyz-eyePos)/fogFar, 0.0, 1.0);
	fogCoef = dist*dist*.50;//*(1.0-texcoord.y);
	fogCoef*=tracks[28];
	a1 = length(p0-p1)/max_radius;
	a1 *= a1;
	a1 = max(0.0, 2.0*sin(.75*3.14*(1.0-texcoord2.x*tracks[27])+t*3.5));
	a1 = 1.;

#if 0
	a1 = 0.0;    
	if (texcoord2.x==20.0)
		a1 = 1.0;
#endif

	la = length(p1-p0);

}

//FRAGMENT
#version 120
varying vec2 tc;
varying vec3 color; 
varying float fogCoef;
varying float a1; 
varying float la;
uniform sampler2D Texture0;
uniform float alpha_mul=1.0; 
uniform float t;
uniform float aa;;
void main() {
	gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);
//	gl_FragColor = texture2D(Texture0, tc);
	gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);
	gl_FragColor.a = 0.2;

	gl_FragColor = vec4(1.0);
	gl_FragColor.a = .250*fogCoef;//*a;

	gl_FragColor = vec4(1.0); vec4(a1);//*(1.0-tc.y);
	//gl_FragColor.a = a1*.1;
	//gl_FragColor.a = tc.y*tc.y*tc.y*tc.y*.226;
	//gl_FragColor = vec4(1.0, 0.0, 0.0, 0.0, 1.0);

	gl_FragColor = vec4(tc, 0.0, 1.0);

	vec4 p = texture2D(Texture0, tc.yx*.5+.25);
	p = texture2D(Texture0, tc.yx);
	gl_FragColor.rgb = p.rgb;
//	gl_FragColor.a = p.r;
	//gl_FragColor.a = .005;
	//gl_FragColor.a = gl_FragColor.r;
	//gl_FragColor.a = .5-gl_Color.r;
//	gl_FragColor.a = 1.0;


//	gl_FragColor.a = a1*.81;
//	gl_FragColor.a *= fogCoef;


	gl_FragColor = vec4(la);
	gl_FragColor *= vec4(fogCoef);
	
	gl_FragColor = vec4(clamp(sin(tc.y*1.0*la-t*10.0), 0.0, 1.0));
	gl_FragColor *= vec4(clamp(sin(tc.x*3.141592), 0.0, 1.0));
	gl_FragColor *= vec4(fogCoef);
	gl_FragColor *= vec4(.5*pow(1.0-tc.y*tc.y, .50));


//	gl_FragColor = vec4(la);

	gl_FragColor.a = .1;
	gl_FragColor.a *= aa;
	
}

